package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * email_template_source
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum EmailTemplateSource {

    _01("01", "屈臣氏-Red-审批通知"),
    _02("02", "屈臣氏-Red-审批驳回通知"),
    _03("03", "屈臣氏-Red-复核通知"),
    _04("04", "屈臣氏-Red-复核驳回通知"),
    _05("05", "屈臣氏-Red-红字确认单确认通知"),
    _06("06", "屈臣氏-Red-上传税局通知"),
    _07("07", "屈臣氏-Red-进项发票异常跟进提醒"),
    _08("08", "屈臣氏-Red-上传税局通知（重新上传）"),
    _09("09", "屈臣氏-销项-业务单开票申请提交"),
    _10("10", "屈臣氏-销项-业务单开票审批通知"),
    _11("11", "屈臣氏-销项-业务单开票审批驳回通知"),
    _12("12", "屈臣氏-销项-业务单开票复核通知"),
    _13("13", "屈臣氏-销项-业务单开票复核驳回通知"),
    _14("14", "屈臣氏-销项-业务单开票通知"),
    _15("15", "屈臣氏-Red-发票作废通知"),
    _16("16", "屈臣氏-销项-业务单上传开票失败通知");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EmailTemplateSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EmailTemplateSource fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            default:
                return null;
        }
    }
}
