package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ftp_item_file_name_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum FtpItemFileNameType {

    _1("1", "W_W tax_by_item.xlsx"),
    _2("2", "仓转的W_S tax_by_item.xlsx 或者 店转的Store_TAX_BY_ITEM.xlsx"),
    _3("3", "682510 Adjustment.xlsx"),
    _4("4", "CA Adjustment.xlsx"),
    _5("5", "仓转的W-S Tax Region Adjustment.xlsx 或者 店转的S-S Tax Region Adjustment.xlsx"),
    _6("6", "仓转的W-S Other Adjustment.xlsx 或者 店转的S-S Other Adjustment.xlsx");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FtpItemFileNameType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FtpItemFileNameType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
