package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * infomation_apply_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum InfomationApplyStatus {

    _1("1", "审核通过"),
    _2("2", "审核不通过"),
    _3("3", "已核销"),
    _4("4", "已撤销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InfomationApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InfomationApplyStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
