package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * item_type_code
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum ItemTypeCode {

    _03("03", "建筑服务"),
    _04("04", "货物运输服务"),
    _05("05", "不动产销售"),
    _06("06", "不动产经营租赁服务");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ItemTypeCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemTypeCode fromCode(String code){
        switch(code) {
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            default:
                return null;
        }
    }
}
