package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operate_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum OperateType {

    _01("01", "提交"),
    _02("02", "审批"),
    _03("03", "复核"),
    _04("04", "跟进"),
    _05("05", "确认红字"),
    _06("06", "关闭"),
    _07("07", "完结"),
    _08("08", "终止"),
    _09("09", "上传税局"),
    _10("10", "系统下发"),
    _11("11", "撤销申请"),
    _12("12", "确认单认领"),
    _13("13", "重新上传"),
    _14("14", "红字认领池退回"),
    _15("15", "保存"),
    _16("16", "发票作废"),
    _17("17", "普票红冲"),
    _18("18", "生成业务单"),
    _19("19", "作废业务单"),
    _20("20", "上传平台"),
    _21("21", "认领");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperateType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            default:
                return null;
        }
    }
}
