package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sales_bill_apply_type
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum SalesBillApplyType {

    _01("01", "业务单开票申请");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesBillApplyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesBillApplyType fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            default:
                return null;
        }
    }
}
