package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * salesbill_initial_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum SalesbillInitialStatus {

    _01("01", "待确认"),
    _02("02", "正常"),
    _03("03", "异常"),
    _04("04", "已作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesbillInitialStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesbillInitialStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            default:
                return null;
        }
    }
}
