package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * salesbill_srouce
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum SalesbillSrouce {

    _0("0", "FTP业务单"),
    _1("1", "平台导入业务单"),
    _2("2", "OTS结算单"),
    _3("3", "红字自动生成"),
    _4("4", "SNC结算单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SalesbillSrouce(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesbillSrouce fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
