package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * sync_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum SyncStatus {

    _0("0", "待同步"),
    _1("1", "同步成功"),
    _2("2", "同步失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SyncStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SyncStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
