package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tag_fail_source
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum TagFailSource {

    HANDLE("handle", "手工导入"),
    SYSTEM("system", "系统");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TagFailSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TagFailSource fromCode(String code){
        switch(code) {
            case "handle":
                return HANDLE;
            case "system":
                return SYSTEM;
            default:
                return null;
        }
    }
}
