package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_rate
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum TaxRate {

    _0("0", "0"),
    _0_01("0.01", "0.01"),
    _0_03("0.03", "0.03"),
    _0_05("0.05", "0.05"),
    _0_06("0.06", "0.06"),
    _0_09("0.09", "0.09"),
    _0_1("0.1", "0.1"),
    _0_13("0.13", "0.13"),
    _0_16("0.16", "0.16"),
    _0_17("0.17", "0.17");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TaxRate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRate fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "0.01":
                return _0_01;
            case "0.03":
                return _0_03;
            case "0.05":
                return _0_05;
            case "0.06":
                return _0_06;
            case "0.09":
                return _0_09;
            case "0.1":
                return _0_1;
            case "0.13":
                return _0_13;
            case "0.16":
                return _0_16;
            case "0.17":
                return _0_17;
            default:
                return null;
        }
    }
}
