package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tmcs_red_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum TmcsRedStatus {

    _1("1", "信息表-审核通过"),
    _2("2", "信息表-审核不通过"),
    _3("3", "信息表-已核销"),
    _4("4", "信息表-已撤销"),
    _5("5", "信息表-其他状态"),
    _00("00", "确认单-待申请"),
    _01("01", "确认单-无需确认"),
    _02("02", "确认单-销方录入待购方确认"),
    _03("03", "确认单-购方录入待销方确认"),
    _04("04", "确认单-购销双方已确认"),
    _05("05", "确认单-作废（销方录入购方否认）"),
    _06("06", "确认单-作废（购方录入销方否认）"),
    _07("07", "确认单-作废（超72小时未确认）"),
    _08("08", "确认单-发起方撤销"),
    _09("09", "确认单-作废（确认后撤销）"),
    _10("10", "确认单-作废（凭证异常）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TmcsRedStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TmcsRedStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "00":
                return _00;
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
