package com.xforceplus.ultraman.app.jcwatsons.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * workflow_status
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
public enum WorkflowStatus {

    _01("01", "待提交"),
    _02("02", "待审批"),
    _03("03", "待复核"),
    _04("04", "审批通过"),
    _05("05", "确认中"),
    _06("06", "待跟进"),
    _07("07", "已完结"),
    _08("08", "待开票"),
    _09("09", "已开票"),
    _10("10", "已作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    WorkflowStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WorkflowStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "04":
                return _04;
            case "05":
                return _05;
            case "06":
                return _06;
            case "07":
                return _07;
            case "08":
                return _08;
            case "09":
                return _09;
            case "10":
                return _10;
            default:
                return null;
        }
    }
}
