package com.xforceplus.ultraman.app.jcwatsons.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class AccountManger implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 分类账
   */
  private String ledger;

  /**
   * 类别
   */
  private String category;

  /**
   * 来源
   */
  private String source;

  /**
   * 币种
   */
  private String currency;

  /**
   * 会计结算日期
   */
  @TableField("accountDate")
  private String accountDate;

  /**
   * 公司代码
   */
  private String company;

  /**
   * 科目代码
   */
  @TableField("naturalAccount")
  private String naturalAccount;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 产品编码
   */
  @TableField("productCoding")
  private String productCoding;

  /**
   * 部门代码
   */
  @TableField("salesChannel")
  private String salesChannel;

  /**
   * 国别
   */
  private String country;

  /**
   * 内部往来公司代码
   */
  @TableField("interCompany")
  private String interCompany;

  /**
   * 项目
   */
  private String project;

  /**
   * 内部往来公司成本中心
   */
  private String spare;

  /**
   * 借项
   */
  private BigDecimal debit;

  /**
   * 贷项
   */
  private BigDecimal credit;

  /**
   * 批名
   */
  @TableField("batchName")
  private String batchName;

  /**
   * 批说明
   */
  @TableField("batchExplanation")
  private String batchExplanation;

  /**
   * 日记账名称
   */
  @TableField("journalName")
  private String journalName;

  /**
   * 行说明
   */
  @TableField("lineDescription")
  private String lineDescription;

  /**
   * 凭证类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 开票日期
   */
  @TableField("paperDrewDate")
  private String paperDrewDate;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 购方名称
   */
  @TableField("buyerName")
  private String buyerName;

  /**
   * 购方税号
   */
  @TableField("buyerTaxNo")
  private String buyerTaxNo;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 所属账期
   */
  private String period;

  /**
   * 税区
   */
  @TableField("rmsCode")
  private String rmsCode;

  /**
   * 红字信息表编号
   */
  @TableField("redLetterNumber")
  private String redLetterNumber;

  /**
   * 组别信息
   */
  private String group;

  /**
   * 归属组别
   */
  @TableField("ascriptionGroup")
  private String ascriptionGroup;

  /**
   * 员工工号
   */
  @TableField("userNumber")
  private String userNumber;

  /**
   * 发票确认渠道
   */
  @TableField("affirmChannel")
  private String affirmChannel;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ledger", ledger);
      map.put("category", category);
      map.put("source", source);
      map.put("currency", currency);
      map.put("accountDate", accountDate);
      map.put("company", company);
      map.put("naturalAccount", naturalAccount);
      map.put("costCenter", costCenter);
      map.put("productCoding", productCoding);
      map.put("salesChannel", salesChannel);
      map.put("country", country);
      map.put("interCompany", interCompany);
      map.put("project", project);
      map.put("spare", spare);
      map.put("debit", debit);
      map.put("credit", credit);
      map.put("batchName", batchName);
      map.put("batchExplanation", batchExplanation);
      map.put("journalName", journalName);
      map.put("lineDescription", lineDescription);
      map.put("documentType", documentType);
      map.put("invoiceType", invoiceType);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceNo", invoiceNo);
      map.put("paperDrewDate", paperDrewDate);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("buyerName", buyerName);
      map.put("buyerTaxNo", buyerTaxNo);
      map.put("taxAmount", taxAmount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("period", period);
      map.put("rmsCode", rmsCode);
      map.put("redLetterNumber", redLetterNumber);
      map.put("group", group);
      map.put("ascriptionGroup", ascriptionGroup);
      map.put("userNumber", userNumber);
      map.put("affirmChannel", affirmChannel);
      map.put("org_tree", orgTree);

      return map;
  }

  public static AccountManger fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    AccountManger entity = new AccountManger();
    if(map.containsKey("ledger")) {
      Object obj = map.get("ledger");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLedger((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accountDate")) {
      Object obj = map.get("accountDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company")) {
      Object obj = map.get("company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("naturalAccount")) {
      Object obj = map.get("naturalAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNaturalAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productCoding")) {
      Object obj = map.get("productCoding");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductCoding((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesChannel")) {
      Object obj = map.get("salesChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("interCompany")) {
      Object obj = map.get("interCompany");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInterCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("project")) {
      Object obj = map.get("project");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spare")) {
      Object obj = map.get("spare");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpare((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("debit")) {
      Object obj = map.get("debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("credit")) {
      Object obj = map.get("credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("batchName")) {
      Object obj = map.get("batchName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchExplanation")) {
      Object obj = map.get("batchExplanation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchExplanation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("journalName")) {
      Object obj = map.get("journalName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJournalName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineDescription")) {
      Object obj = map.get("lineDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("period")) {
      Object obj = map.get("period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rmsCode")) {
      Object obj = map.get("rmsCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRmsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ascriptionGroup")) {
      Object obj = map.get("ascriptionGroup");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAscriptionGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userNumber")) {
      Object obj = map.get("userNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("affirmChannel")) {
      Object obj = map.get("affirmChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAffirmChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ledger")) {
      Object obj = map.get("ledger");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLedger((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source")) {
      Object obj = map.get("source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accountDate")) {
      Object obj = map.get("accountDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company")) {
      Object obj = map.get("company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("naturalAccount")) {
      Object obj = map.get("naturalAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNaturalAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productCoding")) {
      Object obj = map.get("productCoding");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductCoding((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesChannel")) {
      Object obj = map.get("salesChannel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("interCompany")) {
      Object obj = map.get("interCompany");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInterCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("project")) {
      Object obj = map.get("project");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spare")) {
      Object obj = map.get("spare");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpare((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("debit")) {
      Object obj = map.get("debit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDebit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDebit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDebit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDebit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDebit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("credit")) {
      Object obj = map.get("credit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCredit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCredit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCredit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCredit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCredit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("batchName")) {
      Object obj = map.get("batchName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchExplanation")) {
      Object obj = map.get("batchExplanation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchExplanation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("journalName")) {
      Object obj = map.get("journalName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJournalName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineDescription")) {
      Object obj = map.get("lineDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaperDrewDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerName")) {
      Object obj = map.get("buyerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyerTaxNo")) {
      Object obj = map.get("buyerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("period")) {
      Object obj = map.get("period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rmsCode")) {
      Object obj = map.get("rmsCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRmsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group")) {
      Object obj = map.get("group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ascriptionGroup")) {
      Object obj = map.get("ascriptionGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAscriptionGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("userNumber")) {
      Object obj = map.get("userNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("affirmChannel")) {
      Object obj = map.get("affirmChannel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAffirmChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
