package com.xforceplus.ultraman.app.jcwatsons.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 从FTP同步过来的内部交易原数据
 * </p>
 *
 * @author ultraman
 * @since 2025-12-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InternalSalesData implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 销方编号
   */
  @TableField("fromJv")
  private String fromJv;

  /**
   * 购方编号
   */
  @TableField("toJv")
  private String toJv;

  /**
   * sku
   */
  private String item;

  /**
   * 不含税金额
   */
  @TableField("vatExclShipCost")
  private BigDecimal vatExclShipCost;

  /**
   * 不含税运费
   */
  @TableField("vatExclUpCharge")
  private BigDecimal vatExclUpCharge;

  /**
   * 税额
   */
  @TableField("vatAmt")
  private BigDecimal vatAmt;

  /**
   * 含税金额
   */
  @TableField("netShipmentCost")
  private BigDecimal netShipmentCost;

  /**
   * 规格
   */
  private String spec;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 数量
   */
  private BigDecimal quantity;

  /**
   * 单位
   */
  private String unit;

  /**
   * 税率
   */
  @TableField("vatRate")
  private BigDecimal vatRate;

  /**
   * 内部交易类型
   */
  @TableField("internalType")
  private String internalType;

  /**
   * 内部交易数据来源
   */
  @TableField("internalDataSource")
  private String internalDataSource;

  /**
   * 批次号
   */
  @TableField("batchNo")
  private String batchNo;

  /**
   * 数据已使用
   */
  @TableField("isUse")
  private Boolean isUse;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("fromJv", fromJv);
      map.put("toJv", toJv);
      map.put("item", item);
      map.put("vatExclShipCost", vatExclShipCost);
      map.put("vatExclUpCharge", vatExclUpCharge);
      map.put("vatAmt", vatAmt);
      map.put("netShipmentCost", netShipmentCost);
      map.put("spec", spec);
      map.put("itemDesc", itemDesc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("quantity", quantity);
      map.put("unit", unit);
      map.put("vatRate", vatRate);
      map.put("internalType", internalType);
      map.put("internalDataSource", internalDataSource);
      map.put("batchNo", batchNo);
      map.put("isUse", isUse);
      map.put("org_tree", orgTree);

      return map;
  }

  public static InternalSalesData fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InternalSalesData entity = new InternalSalesData();
    if(map.containsKey("fromJv")) {
      Object obj = map.get("fromJv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFromJv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("toJv")) {
      Object obj = map.get("toJv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setToJv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatExclShipCost")) {
      Object obj = map.get("vatExclShipCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatExclShipCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatExclShipCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatExclShipCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatExclShipCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatExclShipCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("vatExclUpCharge")) {
      Object obj = map.get("vatExclUpCharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatExclUpCharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatExclUpCharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatExclUpCharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatExclUpCharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatExclUpCharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("vatAmt")) {
      Object obj = map.get("vatAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("netShipmentCost")) {
      Object obj = map.get("netShipmentCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNetShipmentCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNetShipmentCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNetShipmentCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNetShipmentCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNetShipmentCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("spec")) {
      Object obj = map.get("spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("internalType")) {
      Object obj = map.get("internalType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInternalType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("internalDataSource")) {
      Object obj = map.get("internalDataSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInternalDataSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isUse")) {
      Object obj = map.get("isUse");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsUse((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsUse(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("fromJv")) {
      Object obj = map.get("fromJv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFromJv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("toJv")) {
      Object obj = map.get("toJv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setToJv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item")) {
      Object obj = map.get("item");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatExclShipCost")) {
      Object obj = map.get("vatExclShipCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatExclShipCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatExclShipCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatExclShipCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatExclShipCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatExclShipCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("vatExclUpCharge")) {
      Object obj = map.get("vatExclUpCharge");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatExclUpCharge((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatExclUpCharge(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatExclUpCharge(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatExclUpCharge(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatExclUpCharge(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("vatAmt")) {
      Object obj = map.get("vatAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("netShipmentCost")) {
      Object obj = map.get("netShipmentCost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNetShipmentCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNetShipmentCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNetShipmentCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNetShipmentCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNetShipmentCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("spec")) {
      Object obj = map.get("spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatRate")) {
      Object obj = map.get("vatRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("internalType")) {
      Object obj = map.get("internalType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInternalType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("internalDataSource")) {
      Object obj = map.get("internalDataSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInternalDataSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isUse")) {
      Object obj = map.get("isUse");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsUse((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsUse(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
