package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


/**
 * 系统工作流程实例变量对象feign客户端
 *
 * @author ultraman
 * @date 2024-08-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.SystemWorkflowInstanceVariable;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface SystemWorkflowInstanceVariableFeignApi {

  /**
   * 通过id查询系统工作流程实例变量对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemWorkflowInstanceVariable/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统工作流程实例变量对象
   * @param systemWorkflowInstanceVariable 系统工作流程实例变量对象
   * @return R
   */
  @PostMapping("/systemWorkflowInstanceVariable/add")
  public R save(@RequestBody SystemWorkflowInstanceVariable systemWorkflowInstanceVariable);

  /**
   * 修改系统工作流程实例变量对象
   * @param systemWorkflowInstanceVariable 系统工作流程实例变量对象
   * @return R
   */
  @PostMapping("/systemWorkflowInstanceVariable/update")
  public R updateById(@RequestBody SystemWorkflowInstanceVariable systemWorkflowInstanceVariable);

  /**
   * 通过id删除系统工作流程实例变量对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemWorkflowInstanceVariable/del/{id}" )
  public R removeById(@PathVariable Long id);

}