package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


/**
 * 系统流程节点实例对象feign客户端
 *
 * @author ultraman
 * @date 2024-08-20
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.SystemWorkflowActInstance;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-watsons-match")
public interface SystemWorkflowActInstanceFeignApi {

  /**
   * 通过id查询系统流程节点实例对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemWorkflowActInstance/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统流程节点实例对象
   * @param systemWorkflowActInstance 系统流程节点实例对象
   * @return R
   */
  @PostMapping("/systemWorkflowActInstance/add")
  public R save(@RequestBody SystemWorkflowActInstance systemWorkflowActInstance);

  /**
   * 修改系统流程节点实例对象
   * @param systemWorkflowActInstance 系统流程节点实例对象
   * @return R
   */
  @PostMapping("/systemWorkflowActInstance/update")
  public R updateById(@RequestBody SystemWorkflowActInstance systemWorkflowActInstance);

  /**
   * 通过id删除系统流程节点实例对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemWorkflowActInstance/del/{id}" )
  public R removeById(@PathVariable Long id);

}