package com.xforceplus.ultraman.app.jcwatsonsmatch.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-08-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MatchingInvoiceMain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 销方税号
   */
  @TableField("sellerTaxNo")
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方地址电话
   */
  @TableField("sellerAddrTel")
  private String sellerAddrTel;

  /**
   * 销方银行名称账号
   */
  @TableField("sellerBankInfo")
  private String sellerBankInfo;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方地址电话
   */
  @TableField("purchaserAddrTel")
  private String purchaserAddrTel;

  /**
   * 购方银行名称账号
   */
  @TableField("purchaserBankInfo")
  private String purchaserBankInfo;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 开票日期
   */
  @TableField("paperDrewDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paperDrewDate;

  /**
   * 备注
   */
  private String remark;

  /**
   * 发票类型
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 验真状态
   */
  @TableField("verifyStatus")
  private String verifyStatus;

  /**
   * 发票联影像路径
   */
  @TableField("invoiceImagePath")
  private String invoiceImagePath;

  /**
   * 抵扣联影像图片地址
   */
  @TableField("deductionImagePath")
  private String deductionImagePath;

  /**
   * 状态最后更新时间
   */
  @TableField("statusUpdateTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime statusUpdateTime;

  /**
   * 门店号
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 发票状态
   */
  @TableField("invoiceStatus")
  private String invoiceStatus;

  /**
   * 扩展字段1
   */
  private String attribute1;

  /**
   * 扩展字段2
   */
  private String attribute2;

  /**
   * 未匹配原因
   */
  @TableField("noMatchReason")
  private String noMatchReason;

  /**
   * 未自动匹配原因
   */
  @TableField("noAutomaticMatchReason")
  private String noAutomaticMatchReason;

  /**
   * 发票匹配状态
   */
  @TableField("invoiceMatchStatus")
  private String invoiceMatchStatus;

  /**
   * 锁定状态
   */
  @TableField("lockStatus")
  private String lockStatus;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * Rental发票ID
   */
  @TableField("rentalInvoiceId")
  private String rentalInvoiceId;

  /**
   * 已匹配金额
   */
  @TableField("alreadyMatchAmount")
  private BigDecimal alreadyMatchAmount;

  /**
   * 剩余匹配金额
   */
  @TableField("remainderMatchAmount")
  private BigDecimal remainderMatchAmount;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerName", sellerName);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerBankInfo", sellerBankInfo);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddrTel", purchaserAddrTel);
      map.put("purchaserBankInfo", purchaserBankInfo);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("paperDrewDate", BocpGenUtils.toTimestamp(paperDrewDate));
      map.put("remark", remark);
      map.put("invoiceType", invoiceType);
      map.put("verifyStatus", verifyStatus);
      map.put("invoiceImagePath", invoiceImagePath);
      map.put("deductionImagePath", deductionImagePath);
      map.put("statusUpdateTime", BocpGenUtils.toTimestamp(statusUpdateTime));
      map.put("storeNo", storeNo);
      map.put("invoiceStatus", invoiceStatus);
      map.put("attribute1", attribute1);
      map.put("attribute2", attribute2);
      map.put("noMatchReason", noMatchReason);
      map.put("noAutomaticMatchReason", noAutomaticMatchReason);
      map.put("invoiceMatchStatus", invoiceMatchStatus);
      map.put("lockStatus", lockStatus);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rentalInvoiceId", rentalInvoiceId);
      map.put("alreadyMatchAmount", alreadyMatchAmount);
      map.put("remainderMatchAmount", remainderMatchAmount);

      return map;
  }

  public static MatchingInvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MatchingInvoiceMain entity = new MatchingInvoiceMain();
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verifyStatus")) {
      Object obj = map.get("verifyStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceImagePath")) {
      Object obj = map.get("invoiceImagePath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceImagePath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductionImagePath")) {
      Object obj = map.get("deductionImagePath");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeductionImagePath((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statusUpdateTime")) {
      Object obj = map.get("statusUpdateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStatusUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStatusUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStatusUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStatusUpdateTime(null);
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAttribute2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noMatchReason")) {
      Object obj = map.get("noMatchReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoMatchReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("noAutomaticMatchReason")) {
      Object obj = map.get("noAutomaticMatchReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoAutomaticMatchReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceMatchStatus")) {
      Object obj = map.get("invoiceMatchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalInvoiceId")) {
      Object obj = map.get("rentalInvoiceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalInvoiceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("alreadyMatchAmount")) {
      Object obj = map.get("alreadyMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAlreadyMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAlreadyMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAlreadyMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAlreadyMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAlreadyMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remainderMatchAmount")) {
      Object obj = map.get("remainderMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRemainderMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRemainderMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRemainderMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRemainderMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRemainderMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerBankInfo")) {
      Object obj = map.get("sellerBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserAddrTel")) {
      Object obj = map.get("purchaserAddrTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserAddrTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserBankInfo")) {
      Object obj = map.get("purchaserBankInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserBankInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaperDrewDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaperDrewDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaperDrewDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaperDrewDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verifyStatus")) {
      Object obj = map.get("verifyStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceImagePath")) {
      Object obj = map.get("invoiceImagePath");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceImagePath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deductionImagePath")) {
      Object obj = map.get("deductionImagePath");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeductionImagePath((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statusUpdateTime")) {
      Object obj = map.get("statusUpdateTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStatusUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStatusUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStatusUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStatusUpdateTime(null);
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceStatus")) {
      Object obj = map.get("invoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute1")) {
      Object obj = map.get("attribute1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("attribute2")) {
      Object obj = map.get("attribute2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAttribute2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("noMatchReason")) {
      Object obj = map.get("noMatchReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoMatchReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("noAutomaticMatchReason")) {
      Object obj = map.get("noAutomaticMatchReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoAutomaticMatchReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceMatchStatus")) {
      Object obj = map.get("invoiceMatchStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceMatchStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLockStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalInvoiceId")) {
      Object obj = map.get("rentalInvoiceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalInvoiceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("alreadyMatchAmount")) {
      Object obj = map.get("alreadyMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAlreadyMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAlreadyMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAlreadyMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAlreadyMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAlreadyMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remainderMatchAmount")) {
      Object obj = map.get("remainderMatchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRemainderMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRemainderMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRemainderMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRemainderMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRemainderMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
