package com.xforceplus.ultraman.app.jcwatsonsmatch.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * no_automatic_match_reason_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
public enum NoAutomaticMatchReasonEnum {

    _1("1", "未配置匹配规则"),
    _2("2", "未匹配到对应付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    NoAutomaticMatchReasonEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NoAutomaticMatchReasonEnum fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
