package com.xforceplus.ultraman.app.jcwatsonsmatch.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOffice implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 编号
   */
  @TableField("officeNumber")
  private String officeNumber;

  /**
   * 英文名称
   */
  @TableField("nameUs")
  private String nameUs;

  /**
   * 中文名称
   */
  @TableField("nameCn")
  private String nameCn;

  /**
   * 机构状态
   */
  @TableField("organizationStatus")
  private String organizationStatus;

  /**
   * 成本中心
   */
  @TableField("costCenter")
  private String costCenter;

  /**
   * 市场
   */
  private String market;

  /**
   * 子公司代码
   */
  @TableField("subCompanyCode")
  private String subCompanyCode;

  /**
   * 税区账套
   */
  @TableField("taxRegionCover")
  private String taxRegionCover;

  /**
   * 税区代码
   */
  @TableField("taxRegionCode")
  private String taxRegionCode;

  /**
   * 开业日期
   */
  @TableField("openDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime openDate;

  /**
   * 关店日期
   */
  @TableField("closeDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime closeDate;

  /**
   * 备注
   */
  private String remark;

  /**
   * 企业内部编码
   */
  @TableField("enterpriseCode")
  private String enterpriseCode;

  /**
   * 用途
   */
  private String purpose;

  /**
   * 财务核算码
   */
  @TableField("financeCode")
  private String financeCode;

  /**
   * 实际接场日
   */
  @TableField("actualDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualDate;

  /**
   * 暂估接场日
   */
  @TableField("assessmentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime assessmentDate;

  /**
   * 暂估开业日
   */
  @TableField("expectOpenDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expectOpenDate;

  /**
   * 实际开业日
   */
  @TableField("actualOpenDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualOpenDate;

  /**
   * 创建人
   */
  @TableField("createBy")
  private String createBy;

  /**
   * 创建时间
   */
  @TableField("createDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createDate;

  /**
   * 最后更新人
   */
  @TableField("lastUpdateBy")
  private String lastUpdateBy;

  /**
   * 最后更新时间
   */
  @TableField("lastUpdateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastUpdateDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * Rental办公室基础信息ID
   */
  @TableField("rentalBizOfficeId")
  private String rentalBizOfficeId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("officeNumber", officeNumber);
      map.put("nameUs", nameUs);
      map.put("nameCn", nameCn);
      map.put("organizationStatus", organizationStatus);
      map.put("costCenter", costCenter);
      map.put("market", market);
      map.put("subCompanyCode", subCompanyCode);
      map.put("taxRegionCover", taxRegionCover);
      map.put("taxRegionCode", taxRegionCode);
      map.put("openDate", BocpGenUtils.toTimestamp(openDate));
      map.put("closeDate", BocpGenUtils.toTimestamp(closeDate));
      map.put("remark", remark);
      map.put("enterpriseCode", enterpriseCode);
      map.put("purpose", purpose);
      map.put("financeCode", financeCode);
      map.put("actualDate", BocpGenUtils.toTimestamp(actualDate));
      map.put("assessmentDate", BocpGenUtils.toTimestamp(assessmentDate));
      map.put("expectOpenDate", BocpGenUtils.toTimestamp(expectOpenDate));
      map.put("actualOpenDate", BocpGenUtils.toTimestamp(actualOpenDate));
      map.put("createBy", createBy);
      map.put("createDate", BocpGenUtils.toTimestamp(createDate));
      map.put("lastUpdateBy", lastUpdateBy);
      map.put("lastUpdateDate", BocpGenUtils.toTimestamp(lastUpdateDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rentalBizOfficeId", rentalBizOfficeId);

      return map;
  }

  public static BizOffice fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOffice entity = new BizOffice();
    if(map.containsKey("officeNumber")) {
      Object obj = map.get("officeNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfficeNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameUs")) {
      Object obj = map.get("nameUs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameUs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameCn")) {
      Object obj = map.get("nameCn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNameCn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("organizationStatus")) {
      Object obj = map.get("organizationStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrganizationStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCostCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMarket((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subCompanyCode")) {
      Object obj = map.get("subCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRegionCover")) {
      Object obj = map.get("taxRegionCover");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRegionCover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRegionCode")) {
      Object obj = map.get("taxRegionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openDate")) {
      Object obj = map.get("openDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOpenDate(null);
      }
    }
    if(map.containsKey("closeDate")) {
      Object obj = map.get("closeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCloseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCloseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCloseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCloseDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("enterpriseCode")) {
      Object obj = map.get("enterpriseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEnterpriseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purpose")) {
      Object obj = map.get("purpose");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurpose((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeCode")) {
      Object obj = map.get("financeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFinanceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("actualDate")) {
      Object obj = map.get("actualDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActualDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualDate(null);
      }
    }
    if(map.containsKey("assessmentDate")) {
      Object obj = map.get("assessmentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAssessmentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAssessmentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAssessmentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAssessmentDate(null);
      }
    }
    if(map.containsKey("expectOpenDate")) {
      Object obj = map.get("expectOpenDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpectOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpectOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpectOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpectOpenDate(null);
      }
    }
    if(map.containsKey("actualOpenDate")) {
      Object obj = map.get("actualOpenDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActualOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualOpenDate(null);
      }
    }
    if(map.containsKey("createBy")) {
      Object obj = map.get("createBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateDate(null);
      }
    }
    if(map.containsKey("lastUpdateBy")) {
      Object obj = map.get("lastUpdateBy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastUpdateBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastUpdateDate")) {
      Object obj = map.get("lastUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastUpdateDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rentalBizOfficeId")) {
      Object obj = map.get("rentalBizOfficeId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRentalBizOfficeId((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("officeNumber")) {
      Object obj = map.get("officeNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOfficeNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameUs")) {
      Object obj = map.get("nameUs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameUs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameCn")) {
      Object obj = map.get("nameCn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameCn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("organizationStatus")) {
      Object obj = map.get("organizationStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrganizationStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("costCenter")) {
      Object obj = map.get("costCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCostCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("market")) {
      Object obj = map.get("market");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMarket((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subCompanyCode")) {
      Object obj = map.get("subCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRegionCover")) {
      Object obj = map.get("taxRegionCover");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRegionCover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRegionCode")) {
      Object obj = map.get("taxRegionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openDate")) {
      Object obj = map.get("openDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOpenDate(null);
      }
    }
    if(map.containsKey("closeDate")) {
      Object obj = map.get("closeDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCloseDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCloseDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCloseDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCloseDate(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("enterpriseCode")) {
      Object obj = map.get("enterpriseCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEnterpriseCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purpose")) {
      Object obj = map.get("purpose");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurpose((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("financeCode")) {
      Object obj = map.get("financeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFinanceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("actualDate")) {
      Object obj = map.get("actualDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActualDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActualDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActualDate(null);
      }
    }
    if(map.containsKey("assessmentDate")) {
      Object obj = map.get("assessmentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAssessmentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAssessmentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAssessmentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAssessmentDate(null);
      }
    }
    if(map.containsKey("expectOpenDate")) {
      Object obj = map.get("expectOpenDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpectOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpectOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpectOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpectOpenDate(null);
      }
    }
    if(map.containsKey("actualOpenDate")) {
      Object obj = map.get("actualOpenDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActualOpenDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActualOpenDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualOpenDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActualOpenDate(null);
      }
    }
    if(map.containsKey("createBy")) {
      Object obj = map.get("createBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateDate(null);
      }
    }
    if(map.containsKey("lastUpdateBy")) {
      Object obj = map.get("lastUpdateBy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastUpdateBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastUpdateDate")) {
      Object obj = map.get("lastUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastUpdateDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rentalBizOfficeId")) {
      Object obj = map.get("rentalBizOfficeId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRentalBizOfficeId((String)obj);
        }
      } else {
      }
    }
  }
}
