package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * analysis_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-28
 */
public enum AnalysisEnum {

    _0("0", "未解析"),
    _1("1", "解析成功"),
    _2("2", "解析失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AnalysisEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AnalysisEnum fromCode(String code) {
        return Stream.of(AnalysisEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
