package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_item_match_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-28
 */
public enum InvoiceItemMatchStatusEnum {

    _0("0", "待匹配"),
    _1("1", "已匹配");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceItemMatchStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceItemMatchStatusEnum fromCode(String code) {
        return Stream.of(InvoiceItemMatchStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
