package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-28
 */
public enum InvoiceTypeEnum {

    _6("6", "收据"),
    _7("7", "附件"),
    _1("1", "增值税普通发票"),
    _2("2", "增值税专用发票"),
    _3("3", "增值税电子普票"),
    _4("4", "增值税卷式发票"),
    _5("5", "通用机打发票"),
    _8("8", "增值税电子专票"),
    _10("10", "数电增值税电子普票"),
    _11("11", "数电增值税电子专票"),
    _12("12", "数电增值税纸质普票"),
    _13("13", "数电增值税纸质专票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceTypeEnum fromCode(String code) {
        return Stream.of(InvoiceTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
