package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * seller_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-28
 */
public enum SellerTypeEnum {

    COMPANY("COMPANY", "公司"),
    ALL("ALL", "全部");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SellerTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SellerTypeEnum fromCode(String code) {
        return Stream.of(SellerTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
