package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * charge_type_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
public enum ChargeTypeEnum {

    _0("0", "水电费"),
    _1("1", "租金费"),
    _2("2", "非付款项目");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ChargeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ChargeTypeEnum fromCode(String code) {
        return Stream.of(ChargeTypeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
