package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_match_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
public enum InvoiceMatchStatusEnum {

    _0("0", "待匹配"),
    _1("1", "部分匹配"),
    _2("2", "完全匹配"),
    _3("3", "不可匹配"),
    _4("4", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceMatchStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceMatchStatusEnum fromCode(String code) {
        return Stream.of(InvoiceMatchStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
