package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * matching_field_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
public enum MatchingFieldEnum {

    AMOUNT_WITH_TAX("amountWithTax", "含税金额"),
    EXPENSES_PERIOD("expensesPeriod", "费用期间"),
    INVOICE_ITEM("invoiceItem", "开票项目"),
    INVOICE_ITEM_CATEGORY("invoiceItemCategory", "开票项目大类"),
    SELLER_NAME("sellerName", "销方公司名称"),
    PURCHASER_TAX_NO("purchaserTaxNo", "购方公司税号"),
    PURCHASER_NAME("purchaserName", "购方公司名称"),
    STORE_NO("storeNo", "店铺号");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchingFieldEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchingFieldEnum fromCode(String code) {
        return Stream.of(MatchingFieldEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
