package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * record_validity_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-16
 */
public enum RecordValidityEnum {

    _0("0", "正常"),
    _1("1", "已删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RecordValidityEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RecordValidityEnum fromCode(String code) {
        return Stream.of(RecordValidityEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
