package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_status_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public enum InvoiceStatusEnum {

    _0("0", "只有复印"),
    _1("1", "已审核复印件"),
    _2("2", "收到原件"),
    _3("3", "异常待处理"),
    _4("4", "已退票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatusEnum fromCode(String code) {
        return Stream.of(InvoiceStatusEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
