package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * is_enable_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public enum IsEnableEnum {

    _0("0", "禁用"),
    _1("1", "启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    IsEnableEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsEnableEnum fromCode(String code) {
        return Stream.of(IsEnableEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
