package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * matching_condition_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public enum MatchingConditionEnum {

    _11("11", "一对一"),
    _1N("1n", "一对多"),
    N1("n1", "多对一"),
    NN("nn", "多对多");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    MatchingConditionEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static MatchingConditionEnum fromCode(String code) {
        return Stream.of(MatchingConditionEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
