package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * org_type
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public enum OrgType {

    _0("0", "行政"),
    _1("1", "财务"),
    _2("2", "采购");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OrgType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OrgType fromCode(String code) {
        return Stream.of(OrgType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
