package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.validator;

import com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = null != OrgType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = null != CreationMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = null != OrgStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = null != ReadStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = null != CreateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = null != MessageType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = null != EnableStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = null != VariableType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = null != WorkflowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeEnum.class)) {
            isValid = null != InvoiceTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatusEnum.class)) {
            isValid = null != VerifyStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VerifyStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusEnum.class)) {
            isValid = null != InvoiceStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(NoAutomaticMatchReasonEnum.class)) {
            isValid = null != NoAutomaticMatchReasonEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NoAutomaticMatchReasonEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceMatchStatusEnum.class)) {
            isValid = null != InvoiceMatchStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceMatchStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatusEnum.class)) {
            isValid = null != LockStatusEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeTypeEnum.class)) {
            isValid = null != ChargeTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(RecordValidityEnum.class)) {
            isValid = null != RecordValidityEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RecordValidityEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchingConditionEnum.class)) {
            isValid = null != MatchingConditionEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchingConditionEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTypeEnum.class)) {
            isValid = null != BillTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchingFieldEnum.class)) {
            isValid = null != MatchingFieldEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchingFieldEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(IsEnableEnum.class)) {
            isValid = null != IsEnableEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsEnableEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
