package com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.validator;

import com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcwatsonsmatch.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-08-14
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgType.class.getSimpleName());
            }
        }
        if(clazz.equals(CreationMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreationMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreationMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OrgStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OrgStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OrgStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ReadStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReadStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReadStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CreateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CreateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CreateType.class.getSimpleName());
            }
        }
        if(clazz.equals(MessageType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MessageType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MessageType.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != EnableStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, EnableStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VariableType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VariableType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VariableType.class.getSimpleName());
            }
        }
        if(clazz.equals(WorkflowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WorkflowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WorkflowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(VerifyStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VerifyStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VerifyStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(NoAutomaticMatchReasonEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NoAutomaticMatchReasonEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NoAutomaticMatchReasonEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceMatchStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceMatchStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceMatchStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatusEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockStatusEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockStatusEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(RecordValidityEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RecordValidityEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RecordValidityEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchingConditionEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchingConditionEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchingConditionEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(BillTypeEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillTypeEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchingFieldEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchingFieldEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchingFieldEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(IsEnableEnum.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsEnableEnum.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsEnableEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
