package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.BizOffice;
import com.xforceplus.ultraman.app.jcwatsonsmatch.service.IBizOfficeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-14
 */
@RestController
public class BizOfficeController {

  @Autowired
  private IBizOfficeService bizOfficeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOffice ${table.comment}
   * @return
   */
  @GetMapping("/bizoffices" )
  public XfR getBizOffices(XfPage page, BizOffice bizOffice) {
    return XfR.ok(bizOfficeServiceImpl.page(page, Wrappers.query(bizOffice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizoffices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOfficeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOffice ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizoffices")
  public XfR save(@RequestBody BizOffice bizOffice) {
     return XfR.ok(bizOfficeServiceImpl.save(bizOffice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOffice ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizoffices/{id}")
  public XfR putUpdate(@RequestBody BizOffice bizOffice,@PathVariable Long id) {
      bizOffice.setId(id);
      return XfR.ok(bizOfficeServiceImpl.updateById(bizOffice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOffice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizoffices/{id}")
  public XfR patchUpdate(@RequestBody BizOffice bizOffice,@PathVariable Long id) {
      BizOffice upbizOffice = bizOfficeServiceImpl.getById(id);
      if(upbizOffice != null){
        upbizOffice = ObjectCopyUtils.copyProperties(bizOffice,upbizOffice,true);
      }
      return XfR.ok(bizOfficeServiceImpl.updateById(upbizOffice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizoffices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOfficeServiceImpl.removeById(id));
  }

  @PostMapping("/bizoffices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_office");
     params.put("request", condition);

     return XfR.ok(bizOfficeServiceImpl.querys(params));
  }

}
