package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.MatchingRulesConfig;
import com.xforceplus.ultraman.app.jcwatsonsmatch.service.IMatchingRulesConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-08-14
 */
@RestController
public class MatchingRulesConfigController {

  @Autowired
  private IMatchingRulesConfigService matchingRulesConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param matchingRulesConfig ${table.comment}
   * @return
   */
  @GetMapping("/matchingrulesconfigs" )
  public XfR getMatchingRulesConfigs(XfPage page, MatchingRulesConfig matchingRulesConfig) {
    return XfR.ok(matchingRulesConfigServiceImpl.page(page, Wrappers.query(matchingRulesConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/matchingrulesconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(matchingRulesConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param matchingRulesConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/matchingrulesconfigs")
  public XfR save(@RequestBody MatchingRulesConfig matchingRulesConfig) {
     return XfR.ok(matchingRulesConfigServiceImpl.save(matchingRulesConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param matchingRulesConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/matchingrulesconfigs/{id}")
  public XfR putUpdate(@RequestBody MatchingRulesConfig matchingRulesConfig,@PathVariable Long id) {
      matchingRulesConfig.setId(id);
      return XfR.ok(matchingRulesConfigServiceImpl.updateById(matchingRulesConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param matchingRulesConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/matchingrulesconfigs/{id}")
  public XfR patchUpdate(@RequestBody MatchingRulesConfig matchingRulesConfig,@PathVariable Long id) {
      MatchingRulesConfig upmatchingRulesConfig = matchingRulesConfigServiceImpl.getById(id);
      if(upmatchingRulesConfig != null){
        upmatchingRulesConfig = ObjectCopyUtils.copyProperties(matchingRulesConfig,upmatchingRulesConfig,true);
      }
      return XfR.ok(matchingRulesConfigServiceImpl.updateById(upmatchingRulesConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/matchingrulesconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(matchingRulesConfigServiceImpl.removeById(id));
  }

  @PostMapping("/matchingrulesconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "matching_rules_config");
     params.put("request", condition);

     return XfR.ok(matchingRulesConfigServiceImpl.querys(params));
  }

}
