package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.SystemWorkflowInstanceVariable;
import com.xforceplus.ultraman.app.jcwatsonsmatch.service.ISystemWorkflowInstanceVariableService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流程实例变量对象前端控制器
 *
 * @author ultraman
 * @date 2024-08-14
 */
@RestController
public class SystemWorkflowInstanceVariableController {

  @Autowired
  private ISystemWorkflowInstanceVariableService systemWorkflowInstanceVariableServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowInstanceVariable 系统工作流程实例变量对象
   * @return
   */
  @GetMapping("/systemworkflowinstancevariables" )
  public XfR getSystemWorkflowInstanceVariables(XfPage page, SystemWorkflowInstanceVariable systemWorkflowInstanceVariable) {
    return XfR.ok(systemWorkflowInstanceVariableServiceImpl.page(page, Wrappers.query(systemWorkflowInstanceVariable)));
  }

  /**
   * 通过id查询系统工作流程实例变量对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowinstancevariables/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceVariableServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流程实例变量对象
   * @param systemWorkflowInstanceVariable 系统工作流程实例变量对象
   * @return XfR
   */
  @PostMapping("/systemworkflowinstancevariables")
  public XfR save(@RequestBody SystemWorkflowInstanceVariable systemWorkflowInstanceVariable) {
     return XfR.ok(systemWorkflowInstanceVariableServiceImpl.save(systemWorkflowInstanceVariable));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流程实例变量对象
   * @param systemWorkflowInstanceVariable 系统工作流程实例变量对象
   * @return XfR
   */
  @PutMapping("/systemworkflowinstancevariables/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowInstanceVariable systemWorkflowInstanceVariable,@PathVariable Long id) {
      systemWorkflowInstanceVariable.setId(id);
      return XfR.ok(systemWorkflowInstanceVariableServiceImpl.updateById(systemWorkflowInstanceVariable));
  }

  /**
   * 修改-传入修改的数据系统工作流程实例变量对象
   * @param systemWorkflowInstanceVariable 系统工作流程实例变量对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowinstancevariables/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowInstanceVariable systemWorkflowInstanceVariable,@PathVariable Long id) {
      SystemWorkflowInstanceVariable upsystemWorkflowInstanceVariable = systemWorkflowInstanceVariableServiceImpl.getById(id);
      if(upsystemWorkflowInstanceVariable != null){
        upsystemWorkflowInstanceVariable = ObjectCopyUtils.copyProperties(systemWorkflowInstanceVariable,upsystemWorkflowInstanceVariable,true);
      }
      return XfR.ok(systemWorkflowInstanceVariableServiceImpl.updateById(upsystemWorkflowInstanceVariable));
  }

  /**
   * 通过id删除系统工作流程实例变量对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowinstancevariables/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceVariableServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowinstancevariables/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_instance_variable");
     params.put("request", condition);

     return XfR.ok(systemWorkflowInstanceVariableServiceImpl.querys(params));
  }

}
