package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.SystemWorkflowInstanceVariableHistory;
import com.xforceplus.ultraman.app.jcwatsonsmatch.service.ISystemWorkflowInstanceVariableHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统工作流程实例变量历史对象前端控制器
 *
 * @author ultraman
 * @date 2024-08-14
 */
@RestController
public class SystemWorkflowInstanceVariableHistoryController {

  @Autowired
  private ISystemWorkflowInstanceVariableHistoryService systemWorkflowInstanceVariableHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowInstanceVariableHistory 系统工作流程实例变量历史对象
   * @return
   */
  @GetMapping("/systemworkflowinstancevariablehistorys" )
  public XfR getSystemWorkflowInstanceVariableHistorys(XfPage page, SystemWorkflowInstanceVariableHistory systemWorkflowInstanceVariableHistory) {
    return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.page(page, Wrappers.query(systemWorkflowInstanceVariableHistory)));
  }

  /**
   * 通过id查询系统工作流程实例变量历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowinstancevariablehistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.getById(id));
  }

  /**
   * 新增系统工作流程实例变量历史对象
   * @param systemWorkflowInstanceVariableHistory 系统工作流程实例变量历史对象
   * @return XfR
   */
  @PostMapping("/systemworkflowinstancevariablehistorys")
  public XfR save(@RequestBody SystemWorkflowInstanceVariableHistory systemWorkflowInstanceVariableHistory) {
     return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.save(systemWorkflowInstanceVariableHistory));
  }

  /**
   * 修改-传入修改后的全部数据系统工作流程实例变量历史对象
   * @param systemWorkflowInstanceVariableHistory 系统工作流程实例变量历史对象
   * @return XfR
   */
  @PutMapping("/systemworkflowinstancevariablehistorys/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowInstanceVariableHistory systemWorkflowInstanceVariableHistory,@PathVariable Long id) {
      systemWorkflowInstanceVariableHistory.setId(id);
      return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.updateById(systemWorkflowInstanceVariableHistory));
  }

  /**
   * 修改-传入修改的数据系统工作流程实例变量历史对象
   * @param systemWorkflowInstanceVariableHistory 系统工作流程实例变量历史对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowinstancevariablehistorys/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowInstanceVariableHistory systemWorkflowInstanceVariableHistory,@PathVariable Long id) {
      SystemWorkflowInstanceVariableHistory upsystemWorkflowInstanceVariableHistory = systemWorkflowInstanceVariableHistoryServiceImpl.getById(id);
      if(upsystemWorkflowInstanceVariableHistory != null){
        upsystemWorkflowInstanceVariableHistory = ObjectCopyUtils.copyProperties(systemWorkflowInstanceVariableHistory,upsystemWorkflowInstanceVariableHistory,true);
      }
      return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.updateById(upsystemWorkflowInstanceVariableHistory));
  }

  /**
   * 通过id删除系统工作流程实例变量历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowinstancevariablehistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowinstancevariablehistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_instance_variable_history");
     params.put("request", condition);

     return XfR.ok(systemWorkflowInstanceVariableHistoryServiceImpl.querys(params));
  }

}
