package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.SystemWorkflowUserTask;
import com.xforceplus.ultraman.app.jcwatsonsmatch.service.ISystemWorkflowUserTaskService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统用户任务对象前端控制器
 *
 * @author ultraman
 * @date 2024-08-14
 */
@RestController
public class SystemWorkflowUserTaskController {

  @Autowired
  private ISystemWorkflowUserTaskService systemWorkflowUserTaskServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowUserTask 系统用户任务对象
   * @return
   */
  @GetMapping("/systemworkflowusertasks" )
  public XfR getSystemWorkflowUserTasks(XfPage page, SystemWorkflowUserTask systemWorkflowUserTask) {
    return XfR.ok(systemWorkflowUserTaskServiceImpl.page(page, Wrappers.query(systemWorkflowUserTask)));
  }

  /**
   * 通过id查询系统用户任务对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowusertasks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowUserTaskServiceImpl.getById(id));
  }

  /**
   * 新增系统用户任务对象
   * @param systemWorkflowUserTask 系统用户任务对象
   * @return XfR
   */
  @PostMapping("/systemworkflowusertasks")
  public XfR save(@RequestBody SystemWorkflowUserTask systemWorkflowUserTask) {
     return XfR.ok(systemWorkflowUserTaskServiceImpl.save(systemWorkflowUserTask));
  }

  /**
   * 修改-传入修改后的全部数据系统用户任务对象
   * @param systemWorkflowUserTask 系统用户任务对象
   * @return XfR
   */
  @PutMapping("/systemworkflowusertasks/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowUserTask systemWorkflowUserTask,@PathVariable Long id) {
      systemWorkflowUserTask.setId(id);
      return XfR.ok(systemWorkflowUserTaskServiceImpl.updateById(systemWorkflowUserTask));
  }

  /**
   * 修改-传入修改的数据系统用户任务对象
   * @param systemWorkflowUserTask 系统用户任务对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowusertasks/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowUserTask systemWorkflowUserTask,@PathVariable Long id) {
      SystemWorkflowUserTask upsystemWorkflowUserTask = systemWorkflowUserTaskServiceImpl.getById(id);
      if(upsystemWorkflowUserTask != null){
        upsystemWorkflowUserTask = ObjectCopyUtils.copyProperties(systemWorkflowUserTask,upsystemWorkflowUserTask,true);
      }
      return XfR.ok(systemWorkflowUserTaskServiceImpl.updateById(upsystemWorkflowUserTask));
  }

  /**
   * 通过id删除系统用户任务对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowusertasks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowUserTaskServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowusertasks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_user_task");
     params.put("request", condition);

     return XfR.ok(systemWorkflowUserTaskServiceImpl.querys(params));
  }

}
