package com.xforceplus.ultraman.app.jcwatsonsmatch.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcwatsonsmatch.entity.SystemWorkflowUserTaskHistory;
import com.xforceplus.ultraman.app.jcwatsonsmatch.service.ISystemWorkflowUserTaskHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统用户任务历史对象前端控制器
 *
 * @author ultraman
 * @date 2024-08-18
 */
@RestController
public class SystemWorkflowUserTaskHistoryController {

  @Autowired
  private ISystemWorkflowUserTaskHistoryService systemWorkflowUserTaskHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowUserTaskHistory 系统用户任务历史对象
   * @return
   */
  @GetMapping("/systemworkflowusertaskhistorys" )
  public XfR getSystemWorkflowUserTaskHistorys(XfPage page, SystemWorkflowUserTaskHistory systemWorkflowUserTaskHistory) {
    return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.page(page, Wrappers.query(systemWorkflowUserTaskHistory)));
  }

  /**
   * 通过id查询系统用户任务历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowusertaskhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.getById(id));
  }

  /**
   * 新增系统用户任务历史对象
   * @param systemWorkflowUserTaskHistory 系统用户任务历史对象
   * @return XfR
   */
  @PostMapping("/systemworkflowusertaskhistorys")
  public XfR save(@RequestBody SystemWorkflowUserTaskHistory systemWorkflowUserTaskHistory) {
     return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.save(systemWorkflowUserTaskHistory));
  }

  /**
   * 修改-传入修改后的全部数据系统用户任务历史对象
   * @param systemWorkflowUserTaskHistory 系统用户任务历史对象
   * @return XfR
   */
  @PutMapping("/systemworkflowusertaskhistorys/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowUserTaskHistory systemWorkflowUserTaskHistory,@PathVariable Long id) {
      systemWorkflowUserTaskHistory.setId(id);
      return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.updateById(systemWorkflowUserTaskHistory));
  }

  /**
   * 修改-传入修改的数据系统用户任务历史对象
   * @param systemWorkflowUserTaskHistory 系统用户任务历史对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowusertaskhistorys/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowUserTaskHistory systemWorkflowUserTaskHistory,@PathVariable Long id) {
      SystemWorkflowUserTaskHistory upsystemWorkflowUserTaskHistory = systemWorkflowUserTaskHistoryServiceImpl.getById(id);
      if(upsystemWorkflowUserTaskHistory != null){
        upsystemWorkflowUserTaskHistory = ObjectCopyUtils.copyProperties(systemWorkflowUserTaskHistory,upsystemWorkflowUserTaskHistory,true);
      }
      return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.updateById(upsystemWorkflowUserTaskHistory));
  }

  /**
   * 通过id删除系统用户任务历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowusertaskhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowusertaskhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_user_task_history");
     params.put("request", condition);

     return XfR.ok(systemWorkflowUserTaskHistoryServiceImpl.querys(params));
  }

}
