package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票确认渠道
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum AffirmChannel {

    _1("1", "汇联易移交"),
    _2("2", "租赁系统移交"),
    _3("3", "手工导入"),
    _4("4", "影像采集"),
    _5("5", "风险发票池"),
    _6("6", "海关缴款书"),
    _7("7", "红字进转出");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AffirmChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AffirmChannel fromCode(String code) {
        return Stream.of(AffirmChannel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
