package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红冲申请类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum ApplyReason {

    _0("0", "购方申请—已抵扣"),
    _1("1", "购方申请—未抵扣"),
    _2("2", "销方申请");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyReason(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyReason fromCode(String code) {
        return Stream.of(ApplyReason.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
