package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字确认单状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum ApplyStatus {

    _00("00", "待申请"),
    _02("02", "销方录入待购方确认"),
    _03("03", "购方录入待销方确认"),
    _04("04", "购销双方已确认"),
    _05("05", "作废（销方录入购方否认）"),
    _06("06", "作废（购方录入销方否认）"),
    _07("07", "作废（超72小时未确认)	"),
    _08("08", "发起方撤销"),
    _01("01", "申请中（下发前状态）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApplyStatus fromCode(String code) {
        return Stream.of(ApplyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
