package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 审核状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum AuditStatus {

    _2("2", "已审核"),
    _0("0", "驳回"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code) {
        return Stream.of(AuditStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
