package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证方式
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum AuthStyle {

    _0("0", "默认"),
    _10("10", "平台页面勾选"),
    _11("11", "平台接口勾选"),
    _12("12", "国税底账勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStyle(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStyle fromCode(String code) {
        return Stream.of(AuthStyle.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
