package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 凭证类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum DocumentType {

    _1("1", "增值税专票待认证"),
    _2("2", "增值税专票转异常"),
    _3("3", "增值税专票进项转出");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DocumentType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentType fromCode(String code) {
        return Stream.of(DocumentType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
