package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 完结类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum EndType {

    _01("01", "完结"),
    _02("02", "关闭");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EndType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EndType fromCode(String code) {
        return Stream.of(EndType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
