package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 组别信息
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum Group {

    I002("I002", "Fin-AP"),
    I013("I013", "Fin-TAX");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Group(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Group fromCode(String code) {
        return Stream.of(Group.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
