package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 处理器类型
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum HandleType {

    RESTAPI_DICTIONARY("restapi_dictionary", "主信息字典远程API校验"),
    SINK_KAFKA("sink_kafka", "下发Kafka"),
    BUSINESS_NO("business_no", "业务代码"),
    DICTIONARY_LOCAL("dictionary_local", "主信息本地字典映射"),
    DICTIONARY_LOCAL_DETAIL("dictionary_local_detail", "明细信息本地字典映射"),
    DETAIL_RESTAPI_DICTIONARY("detail_restapi_dictionary", "明细信息字典远程API校验"),
    SINK_JANUS("sink_janus", "下发集成平台");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HandleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HandleType fromCode(String code) {
        return Stream.of(HandleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
