package com.xforceplus.ultraman.app.jcwatsons.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 红字信息表审核状态
 * </p>
 *
 * @author ultraman
 * @since 2023-05-11
 */
public enum InfomationApplyStatus {

    _1("1", "审核通过"),
    _2("2", "审核不通过"),
    _3("3", "已核销"),
    _4("4", "已撤销");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InfomationApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InfomationApplyStatus fromCode(String code) {
        return Stream.of(InfomationApplyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
